// Scilab : 6.0.0
// OS: Windows 7, 64 bit
// Expt. No. 8: To design a Lead Comensator by Bode-plot technique

clc
close
clf();

s=poly(0,'s')
// Transfer Function of Open-Loop System
G=syslin('c',12/((s)*(s+1)))
figure(0)
bode(G,0.1,100)
[gm,frg]=g_margin(G);
disp(gm,"Gain Margin",frg,"Phase Cut-off Frequency")
show_margins(G)
[phm,frp]=p_margin(G);
disp(phm,"Phase Margin",frp,"Gain Cut-off Frequency")
show_margins(G)

// Transfer Function of Open-Loop Compensated System, GGc
GGc=syslin('c',12*(1+0.385*s)/((s)*(s+1)*(1+0.125*s)))

// Bode - Plot of Compensated System
figure(1)
bode(GGc,0.1,100)
[gm,frg]=g_margin(GGc);
disp(gm,"Gain Margin",frg,"Phase Cut-off Frequency")
show_margins(GGc)
[phm,frp]=p_margin(GGc);
disp(phm,"Phase Margin",frp,"Gain Cut-off Frequency")
show_margins(GGc)

// Step Response of Coles-Loop Un-Compensated System
figure(2)
t= 0:0.1:10;
x=[csim('step',t,G/(1+G))]';
plot2d(t',x),xgrid(5, 1, 7)
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Un-Compensated System');

// Step Response of Close-Loop Compensated System
figure(3)
t= 0:0.1:10;
x=[csim('step',t,GGc/(1+GGc))]';
plot2d(t',x),xgrid(5, 1, 7)
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Compensated System');
// Results
// Frequency Response Specifications of Un-Compensated System
//Phase Cut-off Frequency
//
//    []
//
// Gain Margin
//
//   Inf
//
// Gain Cut-off Frequency
//
//   0.5399649
//
// Phase Margin
//
//   16.422908

// Frequency Response Specifications of Compensated System

// Phase Cut-off Frequency
//
//    []
//
// Gain Margin
//
//   Inf
//
// Gain Cut-off Frequency
//
//   0.720447
//
// Phase Margin
//
//   43.107374

